/*
 * main.c
 * copyright (c) 2004 Wei-Keat Kong.
 *
 * Main Loop for running Tk scripts
 *
 * WriteLog: Function to write strings to the log file
 * main: Main loop to set up Tk environment and run xword.tk script
 *
*/

#define USE_TCL_STRUCT 1
#include "main.h"

/*
 * Function: WriteLog
 * Purpose: saves the string along with any arguments to the log file
 * I/O: In  - string, variable number of arguments
 *      Out - none.
 * Returns: none.
 * Functions called: none
*/
void WriteLog(char *sMsg, ...)
{
   va_list ap;
   FILE *fp;

   fp = fopen(LOGFILENAME,"a");

   va_start(ap, sMsg);
   vfprintf(fp, sMsg, ap);
   va_end(ap);
   fclose(fp);
}

/*
 * Function: main
 * Purpose: main loop to run tk scripts. Initializes global variables.
 * I/O: In  - none.
 *      Out - none.
 * Returns: RC_OK
 * Functions called: xword.tk
*/
int main(int argc, char **argv)
{
	char cmd[256];
	static char *display = NULL;
	struct timeval t;
	int i=0;

	if (sizeof(u_long) != 8) {
		fprintf(stderr, "u_long is %ld bytes; we expect 8.\n", sizeof(u_long));
		abort();
	}
	for(i=0;i<MAXGRIDSIZE;i++)
	{
		dict[i].numwords = 0;
		lengths[i] = 0;
	} 
 
	gettimeofday(&t, NULL);
	// srand((unsigned int)t.tv_sec); // see dict.c, where I have srand(1).

	gridstring = Tcl_Alloc(sizeof(utf8_t)*MAXGRIDSTRING);
	NOSOLUTION = 0;
	RIGHTDIRECTION = 0;
	TotalTime = 0.0;
	NumBacktracks = 0;
	memset(gridstring, 0, sizeof(utf8_t)*MAXGRIDSTRING);

	Tcl_FindExecutable(argv[0]);
	interp = Tcl_CreateInterp();

	mainWindow = Tk_CreateWindow(interp, (Tk_Window) display, argv[0], "");

	if (mainWindow == NULL)
	{
		fprintf(stderr, "%s\n", interp->result);
		exit(RC_FAILED);
	}

	if (Tcl_Init(interp) == TCL_ERROR)
	{
		fprintf(stderr, "Tcl_Init failed:  %s\n", interp->result);
		exit(RC_FAILED);
	}
	if (Tk_Init(interp) == TCL_ERROR) 
	{
		fprintf(stderr, "Tk_Init failed:  %s\n", interp->result);
		exit(RC_FAILED);
	}

	Tcl_LinkVar(interp, "gridstring", (char *) &gridstring, 
					TCL_LINK_STRING);

	Tcl_LinkVar(interp, "NOSOLUTION", (char *) &NOSOLUTION, 
					TCL_LINK_INT);

	Tcl_LinkVar(interp, "RIGHTDIRECTION", (char *) &RIGHTDIRECTION, 
					TCL_LINK_INT);

	Tcl_LinkVar(interp, "TotalTime", (char *) &TotalTime, 
					TCL_LINK_DOUBLE);

	Tcl_LinkVar(interp, "NumBacktracks", (char *) &NumBacktracks, 
					TCL_LINK_INT);

	Tcl_CreateCommand(interp, "load_grid", (Tcl_CmdProc *) load_gridCMD,\
							(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "setup_grid", (Tcl_CmdProc *) setup_gridCMD,\
							(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "load_dict", (Tcl_CmdProc *) load_dictCMD,\
							(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "find_dir", (Tcl_CmdProc *) find_dirCMD,\
							(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "backjump", (Tcl_CmdProc *) backjumpCMD,\
							(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
	Tcl_CreateCommand(interp, "get_grid", (Tcl_CmdProc *) get_gridCMD,\
							(ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

	sprintf(cmd, "load libtkimg1.3.so");
	Tcl_Eval(interp, cmd);

	sprintf(cmd, "load libjpegtcl1.0.so");
	Tcl_Eval(interp, cmd);

	sprintf(cmd, "load libtkimgjpeg1.3.so");
	Tcl_Eval(interp, cmd);

	sprintf(cmd, "load libtkimgwindow1.3.so");
	Tcl_Eval(interp, cmd);

	sprintf(cmd, "source xword.tk");
	//sprintf(cmd, "source quick.tk");
	Tcl_Eval(interp, cmd);

	Tk_MainLoop();

	sprintf(cmd, "exit");
	Tcl_Eval(interp, cmd);
	fprintf(stderr, "Exiting...");
	return RC_OK;
}
