#ifndef GLOBAL_H
#define GLOBAL_H

#include <tcl8.4/tcl.h>
#include <tcl8.4/tk.h>
#include <sys/time.h>

#include "bitset.h"
#include "mytypes.h"
#include "utf8/utf8convert.h"
#include "utf8/uniprops.h"

#define RC_OK 0        // OK return code
#define RC_FAILED 1    // Failure return code

#define ACROSS 1       // across direction
#define DOWN 2         // down direction

#define MAXGRIDSIZE 15       // Maxixum size of the grid
#define MAXSTRINGSIZE 100    // Maximum string size when reading from file
#define MAXCOMB 3            // Maximum number of combining characters
#define MAXWORDS 500         // Maximum number of words in the puzzle
#define UCSLETTER MAXCOMB+1  // Size of a UCS character
#define MAXGRIDSTRING 6000   // Maximum size of a string?
#define DICTMAX 100000       // Maximum number of words in a dictionary
#define CHAR_LIMIT 97        // Maximum number of hash values
#define HASH_RETRY 20        // Maximum number of tries for hash collision

typedef struct CONPAIR
{
   u_short idx1;      // Index of the first word
   u_short pos1;      // Character position in the first word
   u_short idx2;      // Index of the second word
   u_short pos2;      // Character position in the second word
} conpair;

typedef struct WLIST
{
   u_short ucslength;  // Length of the UCS character
   wide_t *string;     // Actual string
   char isTaken;       // is this word already used in the puzzle?
} w_list;

typedef struct DICT_IDX
{
   u_long numwords;    // Number of words in the dictionary
   w_list words[DICTMAX];  // The array of word strings
   BitSet array[CHAR_LIMIT][MAXGRIDSIZE];  // Bitset array
} dict_idx;

typedef struct CELL
{
   wide_t letter[UCSLETTER];  // Letter in the cell
   u_short isblack;  // Is cell black?
   u_short constrained; // Does this cell intersect with another word?
   u_short exists;  // Is there already a letter here?
} cell_t;

typedef struct SLOT_LIST
{
   u_short h_idx;         // x cell coordinates
   u_short w_idx;         // y cell coordinates
   u_short direction; // direction: ACROSS or DOWN
   u_short length;    // length of the word on the grid
   u_short ucslength; // length of the string containing the word
   u_long choices;  // how many fitting words are left
   int wordindex; // which word in the dictionary is used
   u_short numconstraint;  // how many constraints
   conpair constraint[MAXGRIDSIZE*2]; //constraint pair <wordindex,pos>
   BitSet *bits;  // if not NULL, a bitset showing the list of words possible
} slot_list_t;

extern void WriteLog(char *sMsg, ...);

// Tk global variables
Tk_Window mainWindow;
Tcl_Interp *interp;
int NOSOLUTION;  // Flag for no solution found
int RIGHTDIRECTION; // Flag for if word reads from right to left
double TotalTime;  // Total time spent solving. In seconds.
long NumBacktracks; // Total number of backtracks.

u_long GRIDSIZE; // Gridsize
u_short NUM_WORDS; // Number of words in the slotlist
char *gridstring;  // Unicode string to display in Tk
u_short lengths[MAXGRIDSIZE]; // How many words needed to solve puzzle
dict_idx dict[MAXGRIDSIZE];  // Dictionary
cell_t grid[MAXGRIDSIZE][MAXGRIDSIZE]; // grid structure
slot_list_t slotlist[MAXWORDS];   // word list to be solved
wide_t mapping[CHAR_LIMIT][UCSLETTER];  // Hash table

#endif
