#ifndef __BITSET_H
#define __BITSET_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

typedef struct BITSET
{
   u_long size;
   u_long *length; // the bit set itself
   int count; // how many bits are set.  -1 means "not yet computed"
} BitSet;

#define NUMLONGBITS 64
#define NUMLONGBITSSHIFT 6
#define NUMLONGBITSMASK 077

#define ON 1
#define OFF 2
#define TOGGLE 3

#define AND 1
#define OR 2
#define XOR 3
#define NOT 4

void BitSetClear(BitSet *set);
u_long BitSetExtract(BitSet *WordSet);
inline long GetBlockSize(BitSet *WordSet);
inline u_long *BitSetFlip(u_long word, BitSet *WordSet, u_short mode);
void BitSetCount(BitSet *WordSet);
void BitSetOP(BitSet *result, BitSet *set1, BitSet *set2, u_short mode);
inline void SelfBitSetOP(BitSet *set1, BitSet *set2, u_short mode);
void BitSetPrint(BitSet *WordSet);
BitSet *CreateBitSet(u_int size, int val);
void FreeBitSet(BitSet *set);

#endif
