#ifndef __LOG_LIB_H
#define __LOG_LIB_H

 
/** \addtogroup logging_lib */
/** @{*/
 
/*! \file log_lib.h
*   \brief This is the header for the Logging Library
*   \author Daniel R. Warren
*   \version 1.0
*   \date    November 2004
*/


#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/time.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>

/** \brief The maximum length of the log message string */
#define LOG_LIB_BUFF_SIZE 150  

/** \brief Used to log to syslogd  */
#define LOGSYSLOG    0x08
/** \brief Used to log to stderr  */
#define LOGSTDERR    0x04
/** \brief Used to log to stdout  */
#define LOGSTDOUT    0x02
/** \brief Used to log to a file  */
#define LOGFILE      0x01


/** \brief Writes log messages to stderr, stdout, syslogd, or a file
 * 
 * This function will write to any combination of the listed locations.  The
 * easiest way to use this is to #define a macro that fills in most of the
 * parameters automatically.  This is shown in the details of this library.
 * 
 * @param message The message to log.
 * @param location The location to log the message.  This value can be any
 *        combination of ( LOGSYSLOG | LOGSTDERR | LOGSTDOUT | LOGFILE )
 * @param process_name The name of the executing process.
 * @param log_file_name The name of the file in which to write the message.
 *        NULL if not writing to a file.
 * @param filename The name of the file in which the log message resides.
 * @param line_num The line number of the log message.
 * @param function The function from which the log message was called.
 * 
**/

void logmessage(char *message, int unsigned location, char *process_name, 
	            char *log_file_name, char *filename, 
		      int line_num, char *function);
           
/** @}*/

#endif
