#ifndef __LINKED_LIST_H
#define __LINKED_LIST_H


/** \addtogroup linked_list_lib */
/** @{*/
 
/*! \file linked_list.h
*   \brief This is the header for the Linked-List Library
*   \author Daniel R. Warren
*   \version 1.0
*   \date    November 2004
*/


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <pthread.h>


/**\todo Modify linked list so that threads aren't blocked to search
 * if there are no modifications being made to the list.
 * This change would make threads that were modifying the list have to
 * wait until all searching threads had completed.
*/
struct node{
   void *data;
   struct node *prev;
   struct node *next;
};
typedef struct node node_t;


struct linked_list{
   size_t elements;
   size_t max_elements;
   node_t *head_of_list;
   pthread_mutex_t list_mutex;
};
typedef struct linked_list linked_list_t;


int linked_list_init(linked_list_t **new_linked_list,
	                	size_t max_elements);

int linked_list_destroy(linked_list_t *list_to_destroy);

int linked_list_insert(linked_list_t *new_linked_list,
                       int (generic_search_w_key)(),
                       void *search_key,
                       void *data_to_add);
                       
void *linked_list_remove(linked_list_t *new_linked_list,
                                  int (generic_search_w_key)(),
                                  void *search_key);

void *linked_list_search(linked_list_t *new_linked_list,
           int (generic_search_w_key)(),
           void *search_key);

void *linked_list_rand_search(linked_list_t *new_linked_list,
                                    int (generic_search_wo_key)());



int linked_list_process_node(linked_list_t *new_linked_list, 
                             int (generic_search_w_key)(),
                             void *search_key,
                             int (generic_processing)(),
                             void *args);

int linked_list_process_all(linked_list_t *new_linked_list,
		                              int (generic_process)(), void *args);
                                    

void *linked_list_compare_all(linked_list_t *new_linked_list,
                                        int (generic_compare_nodes)(),
                                        void *args);

/** @}*/


#endif
