#ifndef __AUTH_LIB_H
#define __AUTH_LIB_H


/** \addtogroup authentication_lib */
/** @{*/
 
/*! \file auth_lib.h
*   \brief This is the header for the Authentication Library
*   \author Daniel R. Warren
*   \version 1.0
*   \date    November 2004
*/


#include "socket_lib.h"
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <openssl/rsa.h>
#include <openssl/engine.h>
#include <openssl/pem.h>
#include <openssl/err.h>


#define AUTH_VALID_MESSAGE "PASSED VERIFICATION"
#define AUTH_INVALID_MESSAGE "FAILED VERIFICATION"
#define AUTH_PUB_KEY_FILE_EXT ".pub"
#define AUTH_MAX_ENCR_MESS_LEN 8.0
#define AUTH_MAX_TEXT_LEN 257
#define AUTH_MAX_MSG_LEN 65536
#define AUTH_SOCK_TIMEOUT 10



/** \brief A server process calls this function to authenticate clients that are
 *         using this library.
 * 
 * Programmers should look over the detailed notes for this library to learn
 * what is needed to use this function.
 * 
 * @param sock A socket descriptor used in communicating with the client to
 *             authenticate.
 * @param pub_key_dir The path to the directory where all of the public keys
 *                    for alsad are stored.

 * @return The function returns 0 on success and -1 on failure.
 * 
 * @see auth_client
 * 
**/

int auth_server(int sock, char *pub_key_dir);



/** \brief A client process calls this function to authenticate with a server
 *         using this library.
 *
 * Programmers should look over the detailed notes for this library to learn
 * what is needed to use this function.
 *
 * 
 * @param sock The socket descriptor used in communicating with the server
 *             process over the network.
 * @param user_name The user name that will be used by the server to determine
 *                  which public key file to use.  
 * @param priv_key_file The path to the client process's private key file.
 * @return The function returns 0 on success and -1 on failure.
 *
 * @see auth_server
**/

int auth_client(int sock, char *user_name, char *priv_key_file);


/** @}*/


#endif

