#ifndef __ALSAD_SHARED_LIB_H
#define __ALSAD_SHARED_LIB_H

/** \addtogroup shared_lib */
/** @{*/
 
/*! \file alsad_shared_lib.h
*   \brief This is the header for the Shared Library
*   \author Daniel R. Warren
*   \version 1.0
*   \date    November 2004
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include <netdb.h>
#include <errno.h>
#include "alsad_defs.h"
#include "alsad_net_lib.h"
#include "auth_lib.h"
#include "config_file.h"

#define ALSAD_PCM_WAIT_TIME 1000
#define ALSAD_RESUME_COUNT 1000


#define ALSAD_KEY_USERNAME "username"
#define ALSAD_KEY_PRIV_KEY_FILE "private_key_file"
#define ALSAD_KEY_PUB_KEY_DIR "public_key_dir"
#define ALSAD_KEY_MAX_STREAM_SINKS "max_stream_sinks"
#define ALSAD_KEY_PCM_FORMAT "pcm_format"
#define ALSAD_KEY_CHANNELS "number_pcm_channels"
#define ALSAD_KEY_OPEN_MODE "card_open_mode"
#define ALSAD_KEY_CIRC_BUFF_SIZE "circ_buff_size"
#define ALSAD_KEY_MAX_CIRC_BUFF_SIZE "max_circ_buff_size"
#define ALSAD_KEY_CARD_BUF_TIME "card_buffer_time"
#define ALSAD_KEY_CARD_PERIOD_TIME "card_period_time"
#define ALSAD_KEY_CARD_DEVICE_NAME "card_device_name"
#define ALSAD_KEY_PORT "alsad_port"

#define ALSAD_DFLT_USERNAME "alsad"
#define ALSAD_DFLT_PRIV_KEY_FILE "~/.ssh/alsad.priv"
#define ALSAD_DFLT_PUB_KEY_DIR "/etc/alsad/pub/"
#define ALSAD_DFLT_MAX_STREAM_SINKS "0"
#define ALSAD_DFLT_PCM_FORMAT "S16_LE"
#define ALSAD_DFLT_CHANNELS "1"
#define ALSAD_DFLT_OPEN_MODE "0"
#define ALSAD_DFLT_CIRC_BUFF_SIZE "1048576"
#define ALSAD_DFLT_MAX_CIRC_BUFF_SIZE "4194304"
#define ALSAD_DFLT_CARD_BUF_TIME "500000"
#define ALSAD_DFLT_CARD_PERIOD_TIME "125000"
#define ALSAD_DFLT_CARD_DEVICE_NAME "default"
#define ALSAD_DFLT_PORT "5000"

#define ALSAD_DFLT_HOSTNAME "localhost"
#define ALSAD_DFLT_RATE 22000 
#define ALSAD_DFLT_IDENTIFIER 123456
#define ALSAD_DFLT_DP_IDENTIFIER 0 


/*! \todo Include everything that you could possibly want to configure
 * in the alsad_config_keys struct so that it can be pulled from the 
 * config files.
 * 
 */

struct alsad_config_keys{
   char *config_username; 
   char *config_priv_key_file;
   char *config_pub_key_dir;
   char *config_max_stream_sinks;
   char *config_pcm_format;
   char *config_channels;
   char *config_open_mode;
   char *config_circ_buff_size;
   char *config_max_circ_buff_size;
   char *config_card_buf_time;
   char *config_card_period_time;
   char *config_card_device_name;
   char *config_port;
};

typedef struct alsad_config_keys alsad_config_keys_t;


int alsad_config_key_load(char *config_file, alsad_config_keys_t *key_struct);

int alsad_conn_with_host(alsad_connect_addr_t *conn_addr,
		alsad_net_structs_t *send_structs,
		char *userid, char *priv_key_file, 
                alsad_control_t *conn_ctrl);



/** Handles executing the alsad protocol after a connection has been established.
 * 
 * More detail here
 * 
 * @param sock the socket descriptor for the current connection
 * @param handle the file handle write/read sound data to/from.
 * @param conn_ctrl to establish the type of alsad connection
 * @see alsad_conn_with_host()
 * @return An integer -1 on failure or 0 on success
 * 
 */
int alsad_handle_client_protocol(int sock, int handle, alsad_control_t *conn_ctrl);

int alsad_client_side_negotiation(int sock, alsad_hw_params_t *hw_params,
                                                           char **audiobuf);
int alsad_server_side_negotiation(int sock, snd_pcm_t **handle,
                     alsad_hw_params_t *rcvd_hw_params, char **audiobuf);

int alsad_configure_snd_card(snd_pcm_t **handle,
		       alsad_stream_props_t *rcvd_stream_props,
	        	alsad_hw_params_t *rcvd_hw_params);

int allocate_audiobuf(alsad_hw_params_t *configd_hw_params, char **audiobuf);

int buffer_xrun(snd_pcm_t *handle, long err_val);

void suspend(snd_pcm_t *handle);

void print_pcm_state(snd_pcm_t *handle);
	
int alsad_hw_playback(snd_pcm_t *handle, alsad_stream_props_t *stream_props,
		                      alsad_hw_params_t *configd_hw_params,
	                                  	char *audio_buf);

int alsad_hw_capture(snd_pcm_t *handle, alsad_stream_props_t *stream_props,
		                     alsad_hw_params_t *configd_hw_params,
	                                 	char *audio_buf);

ssize_t alsad_channel_write(void *channel, void *pipe, char *audiobuf,
	                                	size_t total_to_write);

ssize_t alsad_channel_read(void *channel, void *pipe, char *audiobuf,
	                                	size_t total_to_read);

ssize_t alsad_file_write(int handle, char *audiobuf,
	                                    size_t total_to_write);

ssize_t alsad_file_read(int handle, char *audiobuf,
	                                    size_t total_to_read);

int alsad_strerror(int errnum, char *error_buff, size_t buff_size);

/** @}*/
#endif
