#ifndef __ALSAD_DEFS_H
#define __ALSAD_DEFS_H


//This #define is for the alsa libraries. Do not remove.
#ifndef ALSA_PCM_NEW_HW_PARAMS_API
#define ALSA_PCM_NEW_HW_PARAMS_API
#endif

#define ALSAD_PAYLOAD_SOCK_TIMEOUT 10
#define ALSAD_GENERIC_SOCK_TIMEOUT 10
#define ALSAD_MAX_TRANS_SIZE 100000 
#define ALSAD_MAX_ERR_SIZE 80


#define ALSAD_SEND_HW_PARAMS      0x00000001
#define ALSAD_RECV_HW_PARAMS      0x00000002
#define ALSAD_SEND_SW_PARAMS      0x00000004
#define ALSAD_RECV_SW_PARAMS      0x00000008
#define ALSAD_RECV_AUDIO_BUF      0x00000010
#define ALSAD_SEND_AUDIO_BUF      0x00000020
#define ALSAD_RECV_STREAM_PROPS   0x00000040
#define ALSAD_SEND_STREAM_PROPS   0x00000080
#define ALSAD_RECV_CONN_ADDR      0x00000100
#define ALSAD_SEND_CONN_ADDR      0x00000200
#define ALSAD_RECV_DATA_PIPE      0x00000400
#define ALSAD_SEND_DATA_PIPE      0x00000800

#define ALSAD_RECV_LOCAL_STREAM   0x00001000
#define ALSAD_SEND_LOCAL_STREAM   0x00002000
#define ALSAD_RECV_RMTE_STREAM    0x00004000
#define ALSAD_SEND_RMTE_STREAM    0x00008000
#define ALSAD_RECV_LOCAL_PIPE     0x00010000
#define ALSAD_SEND_LOCAL_PIPE     0x00020000
#define ALSAD_RECV_RMTE_PIPE      0x00040000
#define ALSAD_SEND_RMTE_PIPE      0x00080000

//Client/Server Request Message
#define ALSAD_RQST_ADD_STREAM     0x00010000
#define ALSAD_RQST_DEL_STREAM     0x00020000
#define ALSAD_RQST_ADD_SRC        0x00040000
#define ALSAD_RQST_DEL_SRC        0x00080000
#define ALSAD_RQST_ADD_SINK       0x00100000
#define ALSAD_RQST_DEL_SINK       0x00200000
#define ALSAD_RQST_LIST_STREAM    0x00400000
#define ALSAD_RQST_LIST_PIPE      0x00800000

#define ALSAD_PATH_HW_IFACE       0x01000000
#define ALSAD_PATH_RMTE_SOCK      0x02000000
#define ALSAD_PATH_CUR_SOCK       0x04000000

#define ALSAD_SRC_CALC_RATE       0x01000000
#define ALSAD_SRC_SINK_RATE       0x02000000


#define ALSAD_MSG_KEEP_ALIVE      0x10000000
#define ALSAD_MSG_CLOSE_CONN      0x20000000
#define ALSAD_MSG_RQST_OK         0x40000000 
#define ALSAD_MSG_RQST_ERR        0x80000000 


//Error messages
enum alsad_error {
   ALSAD_ERR_MAX_PIPES,
   ALSAD_ERR_INSUF_INFO,
   ALSAD_ERR_STREAM_FIND,
   ALSAD_ERR_STREAM_REM,
   ALSAD_ERR_STREAM_INS,
   ALSAD_ERR_INVLD_FRMT,
   ALSAD_ERR_INTERNAL,
   ALSAD_ERR_NO_PATH,
   ALSAD_ERR_PIPE_INS,
   ALSAD_ERR_PIPE_REM,
   ALSAD_ERR_PIPE_FIND,
   ALSAD_ERR_LOCAL_ADDR,
   ALSAD_ERR_RMTE_HOST,
   ALSAD_ERR_IFACE_CFG,
   ALSAD_ERR_RECV_CTRL,
   ALSAD_ERR_INVLD_CTRL,
   ALSAD_ERR_RECV_AUDIOHD,
   ALSAD_ERR_RECV_AUDIO,
   ALSAD_ERR_MAX_TRANS,
   ALSAD_ERR_FRAME_DIV,
   ALSAD_ERR_PIPE_CLOSE,
   ALSAD_ERR_STREAM_CLOSE,
   ALSAD_ERR_SHUTDOWN,
   ALSAD_ERR_SRC_PERM
   
};

typedef enum alsad_error alsad_error_t;





#endif
